function allspots = get_allspots(parameters,data_str,offset,gain)

% parameters
Ith = 0.9; % Intensity threshold for spot segmentation
Nmask = 21; % (odd) size of localization mask
Nspots = 1; % Number of spots in frames
Npixels = 256; % Number of camera pixels
Nzfocus = 10;   % Frame number in focus
Nzstack = 21;
Nxpixels = parameters.Mx;
Nypixels = parameters.My;

% pre-allocate
Xspot = zeros(Nspots,Nzstack);
Yspot = zeros(Nspots,Nzstack);
Xplot = zeros(Nspots,Nspots,Nzstack);
Yplot = zeros(Nspots,Nspots,Nzstack);
Setmat = zeros(Npixels,Npixels,Nzstack);
allspots = zeros(Nxpixels,Nypixels,Nzstack,Nspots);

% read data
% experimental PSFs
allimgs_temp = zeros(Npixels,Npixels,Nzstack);
for jj = 1:Nzstack
    allimgs_temp(:,:,jj) = imread([data_str '.tif'],jj);
end

figure;imagesc(allimgs_temp(:,:,Nzfocus))
allimgs = allimgs_temp(65-29:65+29,88-29:88+29,:);
% allimgs = allimgs_temp;
figure;imagesc(allimgs(:,:,Nzfocus))
[Npixels,~,~] = size(allimgs);


% segmentation, localization and ROI
Setmat = ...
    get_segmentation(allimgs(:,:,Nzfocus),Nmask,Ith);

[Xspot,Yspot] = ...
    get_localization(allimgs(:,:,Nzfocus),Setmat,Npixels,Nspots,Ith);

% ROI coordinates
Xplot = [Xspot-floor(Nxpixels/2) Xspot+floor(Nxpixels/2)];
Yplot = [Yspot-floor(Nypixels/2) Yspot+floor(Nypixels/2)];

% dubplicate coordinates for fixed ROI
Xplot = repmat(Xplot,[1 1 Nzstack]);
Yplot = repmat(Yplot,[1 1 Nzstack]);

% ROI spots
for ii = 1:Nspots
    for jj = 1:Nzstack
        allspots(:,:,jj,ii) = allimgs(Xplot(ii,1,jj):Xplot(ii,2,jj),Yplot(ii,1,jj):Yplot(ii,2,jj),jj);
    end
end

allspots = (allspots-offset).*gain;

figure
imagesc((allimgs(:,:,Nzfocus)-offset).*gain)
hold on; box on; axis square

for jstep = 1:Nspots
rectangle('Position',[Yplot(jstep,1,Nzfocus),Xplot(jstep,1,Nzfocus),Nxpixels-1,Nxpixels-1],...
    'LineWidth',1.5,'LineStyle','-','EdgeColor',[1 1 1])
text(Yplot(jstep,2),Xplot(jstep,1),[num2str(jstep) ') ROI = ' num2str(Nxpixels) 'x' num2str(Nypixels)],'Color',[1 1 1])

rectangle('Position',[10,10,Nmask,Nmask],...
    'LineWidth',1.5,'LineStyle','-','EdgeColor',[1 1 1])
text(10+Nmask,10,[' localization mask ' num2str(Nmask) 'x' num2str(Nmask)],'Color',[1 1 1])

end



end